;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   TRIADC8_1.asm
;;  Version: 1.0.0.13, Updated on 2004/07/07 at 17:55:40
;;  Generated by PSoC Designer ver 4.2 BETA b1005 : 09 July, 2004
;;
;;  DESCRIPTION: TriADC User Module software implementation file
;;               for the 25/26xxx PSoC family of devices.
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2001-2003. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "TRIADC8_1.inc"
include "m8c.inc"
include "memory.inc"

;-----------------------------------------------
;  Global Symbols
;-----------------------------------------------
export  TRIADC8_1_Start
export _TRIADC8_1_Start
export  TRIADC8_1_SetPower
export _TRIADC8_1_SetPower
export  TRIADC8_1_Stop
export _TRIADC8_1_Stop
export  TRIADC8_1_GetSamples
export _TRIADC8_1_GetSamples
export  TRIADC8_1_StopAD
export _TRIADC8_1_StopAD
export  TRIADC8_1_fIsData
export _TRIADC8_1_fIsData
export  TRIADC8_1_fIsDataAvailable
export _TRIADC8_1_fIsDataAvailable
export  TRIADC8_1_cGetData1
export _TRIADC8_1_cGetData1
export  TRIADC8_1_cGetData2
export _TRIADC8_1_cGetData2
export  TRIADC8_1_cGetData3
export _TRIADC8_1_cGetData3
export  TRIADC8_1_ClearFlag
export _TRIADC8_1_ClearFlag
export  TRIADC8_1_cGetData1ClearFlag
export _TRIADC8_1_cGetData1ClearFlag
export  TRIADC8_1_cGetData2ClearFlag
export _TRIADC8_1_cGetData2ClearFlag
export  TRIADC8_1_cGetData3ClearFlag
export _TRIADC8_1_cGetData3ClearFlag
export  TRIADC8_1_SetCalcTime
export _TRIADC8_1_SetCalcTime

export  TRIADC8_1_iCalcTime  
export _TRIADC8_1_iCalcTime  

;-----------------------------------------------
;  Constants
;-----------------------------------------------
LowByte:       equ 1
HighByte:      equ 0

;-----------------------------------------------
;  Variable Allocation
;-----------------------------------------------
area u1_RAM (RAM, REL, CON)                  
_TRIADC8_1_iCalcTime:
 TRIADC8_1_iCalcTime:    BLK   2   ; CalcTime variable



AREA UserModules (ROM, REL)
.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_Start
;  FUNCTION NAME: TRIADC8_1_SetPower
;
;  DESCRIPTION:
;     Applies power setting to the module's analog PSoc block.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    A contains the power setting (0 - 3)
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 TRIADC8_1_Start:
_TRIADC8_1_Start:
 TRIADC8_1_SetPower:
_TRIADC8_1_SetPower:
   RAM_PROLOGUE RAM_USE_CLASS_2
   and   A,TRIADC8_1_bfPOWERMASK                     ; Mask only the valid power setting bits
   mov   X, SP                                       ; Get location of next location on stack
   push  A                                           ; Save power value on temp location

                                                     ; Set power for ADC1
   mov   A, reg[TRIADC8_1_bfADC1cr3]                 ; Get current value of ADC1cr3
   and   A, ~TRIADC8_1_bfPOWERMASK                   ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC8_1_bfADC1cr3], A                 ; Reload CR with new power value

                                                     ; Set power for ADC2
   mov   A, reg[TRIADC8_1_bfADC2cr3]                 ; Get current value of ADC2cr3
   and   A, ~TRIADC8_1_bfPOWERMASK                   ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC8_1_bfADC2cr3], A                 ; Reload CR with new power value

                                                     ; Set power for ADC3
   mov   A, reg[TRIADC8_1_bfADC3cr3]                 ; Get current value of ADC3cr3
   and   A, ~TRIADC8_1_bfPOWERMASK                   ; Mask off old power value
   or    A, [X]                                      ; OR in new power value
   or    A, f0h                                      ; Make sure other register is set correctly
   mov   reg[TRIADC8_1_bfADC3cr3], A                 ; Reload CR with new power value

   pop   A                                           ; Restore the stack and power value
   RAM_EPILOGUE RAM_USE_CLASS_2
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_Stop
;
;  DESCRIPTION:
;    Removes power from the module's analog PSoc block, but the digital
;    blocks keep on running.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 TRIADC8_1_Stop:
_TRIADC8_1_Stop:
   RAM_PROLOGUE RAM_USE_CLASS_1
   and   reg[TRIADC8_1_bfADC1cr3], ~TRIADC8_1_bfPOWERMASK
   and   reg[TRIADC8_1_bfADC2cr3], ~TRIADC8_1_bfPOWERMASK
   and   reg[TRIADC8_1_bfADC3cr3], ~TRIADC8_1_bfPOWERMASK
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_Get_Samples
;
;  DESCRIPTION:
;    Starts the A/D convertor and will place data is memory.  A flag
;    is set whenever a new data value is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    None
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_GetSamples:
_TRIADC8_1_GetSamples:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iCalcTime

   call  TRIADC8_1_StopAD                                  ; Halt PWM and counter, Disable
                                                           ; Interrupts, Put A/D in reset

   mov   reg[TRIADC8_1_bPWM_IntTime_LSB], 00h
   mov   reg[TRIADC8_1_bPWM_IntTime_MSB], 0x04

                                                   ; Load the CalcTime into the PWM Period
   mov   A,[TRIADC8_1_iCalcTime+LowByte]
   mov   reg[TRIADC8_1_bPWM_Period_LSB],A
   mov   A,0x4
   add   A,[TRIADC8_1_iCalcTime+HighByte]
   mov   reg[TRIADC8_1_bPWM_Period_MSB],A

   RAM_SETPAGE_CUR >TRIADC8_1_cCounter1U
IF (TRIADC8_1_DATA_FORMAT)
   mov   [TRIADC8_1_cCounter1U], 0xFE                      ; Place result back into MSB of counter1
   mov   [TRIADC8_1_cCounter2U], 0xFE                      ; Place result back into MSB of counter2
   mov   [TRIADC8_1_cCounter3U], 0xFE                      ; Place result back into MSB of counter3
ELSE
   mov   [TRIADC8_1_cCounter1U], 00h                       ; Always start at zero for unsigned values for ADC1
   mov   [TRIADC8_1_cCounter2U], 00h                       ; Always start at zero for unsigned values for ADC2
   mov   [TRIADC8_1_cCounter3U], 00h                       ; Always start at zero for unsigned values for ADC3
ENDIF
   mov   A, reg[TRIADC8_1_bPWM_IntTime_LSB]                ; Dummy Read  - required do not remove
   mov   reg[TRIADC8_1_bPeriod1], FFh                      ; Make sure counter1 starts at FF
   mov   reg[TRIADC8_1_bPeriod2], FFh                      ; Make sure counter1 starts at FF
   mov   reg[TRIADC8_1_bPeriod3], FFh                      ; Make sure counter1 starts at FF

   and   reg[TRIADC8_1_bfADC1cr3],~TRIADC8_1_fFSW0         ; Take Integrator out of reset
   and   reg[TRIADC8_1_bfADC2cr3],~TRIADC8_1_fFSW0         ; Take Integrator out of reset
   and   reg[TRIADC8_1_bfADC3cr3],~TRIADC8_1_fFSW0         ; Take Integrator out of reset
IF TRIADC8_1_NoAZ
    and  reg[TRIADC8_1_bfADC1cr2],~TRIADC8_1_fAutoZero     ; Take Integrator out of AutoZero
    and  reg[TRIADC8_1_bfADC2cr2],~TRIADC8_1_fAutoZero     ; Take Integrator out of AutoZero
    and  reg[TRIADC8_1_bfADC3cr2],~TRIADC8_1_fAutoZero     ; Take Integrator out of AutoZero
ENDIF

                                                               ; Enable the A/D and Start it!
   or    reg[TRIADC8_1_bCounter1_CR0], (TRIADC8_1_fDBLK_ENABLE|TRIADC8_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC8_1_bCounter2_CR0], (TRIADC8_1_fDBLK_ENABLE|TRIADC8_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC8_1_bCounter3_CR0], (TRIADC8_1_fDBLK_ENABLE|TRIADC8_1_fPULSE_WIDE)   ; Enable the Counter
   or    reg[TRIADC8_1_fPWM_LSB_CR0], TRIADC8_1_fDBLK_ENABLE          ; Enable PWM
   or    reg[TRIADC8_1_bfPWM16_INT_REG], TRIADC8_1_bfPWM16_Mask   ; Enable PWM and Counter interrupts
   or    reg[TRIADC8_1_bfCounter1_INT_REG], TRIADC8_1_bfCounter1_Mask
   or    reg[TRIADC8_1_bfCounter2_INT_REG], TRIADC8_1_bfCounter2_Mask
   or    reg[TRIADC8_1_bfCounter3_INT_REG], TRIADC8_1_bfCounter3_Mask
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_StopAD
;
;  DESCRIPTION:
;    Completely shuts down the A/D is an orderly manner.  Both the
;    Timer and Counter are disabled and their interrupts are deactivated.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;
 TRIADC8_1_StopAD:
_TRIADC8_1_StopAD:
   RAM_PROLOGUE RAM_USE_CLASS_1
   and   reg[TRIADC8_1_fPWM_LSB_CR0], ~TRIADC8_1_fDBLK_ENABLE     ; Disable the PWM

   and   reg[TRIADC8_1_bCounter1_CR0], ~TRIADC8_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC8_1_bCounter2_CR0], ~TRIADC8_1_fDBLK_ENABLE           ; Disable the Counter
   and   reg[TRIADC8_1_bCounter3_CR0], ~TRIADC8_1_fDBLK_ENABLE           ; Disable the Counter

IF TRIADC8_1_NoAZ
   or    reg[TRIADC8_1_bfADC1cr2], TRIADC8_1_fAutoZero         ; Put the Integrator into Autozero mode
   or    reg[TRIADC8_1_bfADC2cr2], TRIADC8_1_fAutoZero         ; Put the Integrator into Autozero mode
   or    reg[TRIADC8_1_bfADC3cr2], TRIADC8_1_fAutoZero         ; Put the Integrator into Autozero mode
ENDIF

   or   reg[TRIADC8_1_bfADC1cr3], TRIADC8_1_fFSW0              ; Put Integrator into reset
   or   reg[TRIADC8_1_bfADC2cr3], TRIADC8_1_fFSW0              ; Put Integrator into reset
   or   reg[TRIADC8_1_bfADC3cr3], TRIADC8_1_fFSW0              ; Put Integrator into reset

   push A
   M8C_DisableIntMask TRIADC8_1_bfPWM16_INT_REG, TRIADC8_1_bfPWM16_Mask      ; Disable interrupts
   M8C_DisableIntMask TRIADC8_1_bfCounter1_INT_REG, TRIADC8_1_bfCounter1_Mask
   M8C_DisableIntMask TRIADC8_1_bfCounter2_INT_REG, TRIADC8_1_bfCounter2_Mask
   M8C_DisableIntMask TRIADC8_1_bfCounter3_INT_REG, TRIADC8_1_bfCounter3_Mask
   pop  A
   RAM_EPILOGUE RAM_USE_CLASS_1
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_fIsData
;  FUNCTION NAME: TRIADC8_1_fIsDataAvailable
;
;  DESCRIPTION:
;    Returns the status of the A/D Data is set whenever a new data value
;    is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: A returns data status in A.  A != 0  Data available
;                                        A  = 0  Data not available
;
;  SIDE EFFECTS:
;    RThe A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_fIsData:
_TRIADC8_1_fIsData:
 TRIADC8_1_fIsDataAvailable:
_TRIADC8_1_fIsDataAvailable:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_bfStatus
   mov   A, [TRIADC8_1_bfStatus]                      ; Get status byte
   and   A, TRIADC8_1_fDATA_READY                     ; Mask off other bits
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_cGetData1
;  FUNCTION NAME: TRIADC8_1_cGetData1ClearFlag
;
;  DESCRIPTION:
;    Returns the data from the A/D.  Does not check if data is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:
;     A contains 8 bit ADC result.
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_cGetData1ClearFlag:
_TRIADC8_1_cGetData1ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult1
   and   [TRIADC8_1_bfStatus], ~TRIADC8_1_fDATA_READY  ; Clear Data ready bit
   mov   A, [(TRIADC8_1_iResult1 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC8_1_cGetData1:
_TRIADC8_1_cGetData1:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult1
   mov   A, [(TRIADC8_1_iResult1 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_cGetData2
;  FUNCTION NAME: TRIADC8_1_cGetData2ClearFlag
;
;  DESCRIPTION:
;    Returns the data from the A/D.  Does not check if data is available.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:
;     A contains 8 bit ADC result.
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_cGetData2ClearFlag:
_TRIADC8_1_cGetData2ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult2
   and   [TRIADC8_1_bfStatus], ~TRIADC8_1_fDATA_READY  ; Clear Data ready bit
   mov   A, [(TRIADC8_1_iResult2 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC8_1_cGetData2:
_TRIADC8_1_cGetData2:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult2
   mov   A, [(TRIADC8_1_iResult2 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_cGetData3
;  FUNCTION NAME: TRIADC8_1_cGetData3ClearFlag
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;
;  RETURNS:
;     A contains 8 bit ADC result.
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_cGetData3ClearFlag:
_TRIADC8_1_cGetData3ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult3
   and   [TRIADC8_1_bfStatus], ~TRIADC8_1_fDATA_READY  ; Clear Data ready bit
   mov   A, [(TRIADC8_1_iResult3 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret

 TRIADC8_1_cGetData3:
_TRIADC8_1_cGetData3:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iResult3
   mov   A, [(TRIADC8_1_iResult3 + LowByte)]
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_ClearFlag
;
;  DESCRIPTION:
;    Clears the data ready flag.
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS: none
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_ClearFlag:
_TRIADC8_1_ClearFlag:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_bfStatus
   and   [TRIADC8_1_bfStatus], ~TRIADC8_1_fDATA_READY  ; Clear Data ready bit
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: TRIADC8_1_SetCalcTime
;
;  DESCRIPTION:
;    Set the CalcTime of the ADC.  Adds this value to the ADC PWM period
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:
;    X:A  16-Bit Calc Value
;
;  RETURNS:
;
;  SIDE EFFECTS:
;    The A and X registers may be modified by this or future implementations
;    of this function.  The same is true for all RAM page pointer registers in
;    the Large Memory Model.  When necessary, it is the calling function's
;    responsibility to perserve their values across calls to fastcall16 
;    functions.
;          
;    Currently only the page pointer registers listed below are modified: 
;          CUR_PP
;
 TRIADC8_1_SetCalcTime:
_TRIADC8_1_SetCalcTime:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_SETPAGE_CUR >TRIADC8_1_iCalcTime
   mov  [TRIADC8_1_iCalcTime+LowByte],A
   mov  [TRIADC8_1_iCalcTime+HighByte],X
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

; End of File TRIADC8_1.asm
